/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DataPackRegistriesHooks {
    private static Map<ResourceKey<? extends Registry<?>>, RegistryAccess.RegistryData<?>> REGISTRY_ACCESS_REGISTRIES_COPY;
    private static final Set<ResourceKey<? extends Registry<?>>> SYNCED_CUSTOM_REGISTRIES;
    private static final Set<ResourceKey<? extends Registry<?>>> SYNCED_CUSTOM_REGISTRIES_VIEW;

    private DataPackRegistriesHooks() {
    }

    public static Map<ResourceKey<? extends Registry<?>>, RegistryAccess.RegistryData<?>> grabBuiltinRegistries(ImmutableMap.Builder<ResourceKey<? extends Registry<?>>, RegistryAccess.RegistryData<?>> builder) {
        REGISTRY_ACCESS_REGISTRIES_COPY = new HashMap((Map<ResourceKey<? extends Registry<?>>, RegistryAccess.RegistryData<?>>)builder.build());
        SYNCED_CUSTOM_REGISTRIES.clear();
        return Collections.unmodifiableMap(REGISTRY_ACCESS_REGISTRIES_COPY);
    }

    public static <T> void addRegistryCodec(@NotNull RegistryAccess.RegistryData<T> data) {
        ResourceKey registryKey = data.f_123101_();
        REGISTRY_ACCESS_REGISTRIES_COPY.put(registryKey, data);
        if (data.f_123103_() != null) {
            SYNCED_CUSTOM_REGISTRIES.add(registryKey);
        }
    }

    public static Set<ResourceKey<? extends Registry<?>>> getSyncedCustomRegistries() {
        return SYNCED_CUSTOM_REGISTRIES_VIEW;
    }

    static {
        SYNCED_CUSTOM_REGISTRIES = new HashSet();
        SYNCED_CUSTOM_REGISTRIES_VIEW = Collections.unmodifiableSet(SYNCED_CUSTOM_REGISTRIES);
    }
}

